//
//  MeetingSDKWrap.cpp
//  meetingservice
//
//  Created by wang yong on 5/27/13.
//  Copyright (c) 2013 weifeshe. All rights reserved.
//

#include "MeetingSDKWrap.h"
#include "MeetingApiDelegate.h"
#include "autoupgrade/MeetingSDKMgr.h"
#include "csf/logger/CSFLogger.h"
#include "services/impl/NetUtilBridge.h"

namespace CSFUnified
{

    CSFLogger* meetingSDKWrapLogger = CSFLogger_getLogger("MeetingService-MeetingSDKWrap");
    MeetingSDKWrap* MeetingSDKWrap::m_pInstance = NULL;
    
    MeetingSDKWrap::MeetingSDKWrap()
    {
        m_bIsSDKLoadSuccessfull = loadSDKModule();
        if (!m_bIsSDKLoadSuccessfull)
        {
            return;
        }
        
        FeatureCapability featureCap;
        createJMSDK(MeetingApiDelegate::getInstance(), featureCap);
    }
    
    MeetingSDKWrap::~MeetingSDKWrap()
    {
        if (NULL != m_pInstance)
        {
            if (m_bIsSDKLoadSuccessfull)
            {
                deleteJMSDK();
            }
            
            m_pInstance = NULL;
        }
    }
    
    void MeetingSDKWrap::startMeetingSDK()
    {
        if (m_MeetingNetUtilTransport == NULL && m_unifiedFactory != NULL)
        {
            m_MeetingNetUtilTransport.reset(new NetUtilTransport(m_unifiedFactory));
            setNetworkTransport(m_MeetingNetUtilTransport.get());
        }
        m_IJMSDKInstanceImpl.startJMSDK();
    }
    
    void MeetingSDKWrap::stopMeetingSDK()
    {
        if (m_MeetingNetUtilTransport != NULL)
        {
            m_MeetingNetUtilTransport->CancelAllRequest();
        }
        m_IJMSDKInstanceImpl.stopJMSDK();
    }
    
    void MeetingSDKWrap::networkChanged(bool bConnected)
    {
        if (bConnected)
        {
            return;
        }
        
        if (m_MeetingNetUtilTransport != NULL)
        {
            m_MeetingNetUtilTransport->CancelAllRequest();
        }
    }
    
    bool MeetingSDKWrap::loadSDKModule()
    {
        m_libHandle = MeetingSDKMgr::getInstance()->getSDKModule();
        if (NULL == m_libHandle)
        {
            if (!MeetingSDKMgr::getInstance()->loadSDKModule())
            {
                CSFLogErrorS(meetingSDKWrapLogger, "Load Meeting SDK module failed.");
                return false;
            }
            m_libHandle = MeetingSDKMgr::getInstance()->getSDKModule();
        }
        
        m_IDSMgrImpl.FuncInit(m_libHandle);
        m_IWbxMeetingAccountQueryImpl.FuncInit(m_libHandle);
        m_IWbxMeetingAccountOperatorImpl.FuncInit(m_libHandle);
        m_IWbxMeetingAccountValidationImpl.FuncInit(m_libHandle);
        m_IInstantMeetingMgrImpl.FuncInit(m_libHandle);
        m_IMeetingCalendarImpl.FuncInit(m_libHandle);
        m_IJMSDKInstanceImpl.FuncInit(m_libHandle);
        
        m_IJabberMeetingSDKDelegateWrapper.FuncInit(m_libHandle);
        m_IMeetingCalendarEventWrapper.FuncInit(m_libHandle);
        m_IWbxMeetingAccountValidationEventWrapper.FuncInit(m_libHandle);
        m_IDSEventWrapper.FuncInit(m_libHandle);
        m_IJMLoggerWrapper.FuncInit(m_libHandle);
        m_INetworkTransportWrapper.FuncInit(m_libHandle);
        
        return true;
    }
    
    
    void MeetingSDKWrap::freeSDKModule()
    {
        m_IDSMgrImpl.FuncUnInit();
        m_IWbxMeetingAccountQueryImpl.FuncUnInit();
        m_IWbxMeetingAccountOperatorImpl.FuncUnInit();
        m_IWbxMeetingAccountValidationImpl.FuncUnInit();
        m_IInstantMeetingMgrImpl.FuncUnInit();
        m_IMeetingCalendarImpl.FuncUnInit();
        m_IJMSDKInstanceImpl.FuncUnInit();

        m_IJabberMeetingSDKDelegateWrapper.SetHandler(NULL);
        m_IMeetingCalendarEventWrapper.SetHandler(NULL);
        m_IWbxMeetingAccountValidationEventWrapper.SetHandler(NULL);
        m_IDSEventWrapper.SetHandler(NULL);
        m_IJMLoggerWrapper.SetHandler(NULL);
        m_INetworkTransportWrapper.FuncInit(NULL);
        
        deleteJMSDK();
        
        MeetingSDKMgr::getInstance()->unloadSDKModule();
    }
    
}
